using DataContracts;
using System.Linq;
using System.Runtime.CompilerServices;

namespace Ato.EN.IntegrationServices.CodeGenerationTRTAMI
{
    public partial class TRTAMI2026Validator
    {
        #region VR.ATO.TRTAMI.000189
        [MethodImpl(MethodImplOptions.AggressiveInlining)]
        public virtual void VRATOTRTAMI000189()
        {
            ProcessMessageDocument processMessage;
            bool assertion;

            /*  VR.ATO.TRTAMI.000189
            If any Trustee Liabilities amounts, or any Statement of Attribution (SA) Taxable Determined Member Component amounts have a positive value, then 'Is any tax payable by the trustee?' must be 'yes'.

            Technical Business Rule Format:
            ^TRTAMI33 <> '1' AND (^TRTAMI35 > 0 OR ^TRTAMI36 > 0 OR ^TRTAMI39 > 0 OR ^TRTAMI40 > 0 OR AnyOccurrence(^TRTAMI82, ^TRTAMI82 > 0))
    
            Data Elements:
    
            ^TRTAMI33 = TRTAMI:RP:OtherReportingInformation:Report.Statement.Summary.PaymentRefundOrNil.Code
    
            ^TRTAMI35 = TRTAMI:RP:TrusteeLiabilities:IncomeTax.TrustComponentDeficitOffset.Amount
    
            ^TRTAMI36 = TRTAMI:RP:TrusteeLiabilities:IncomeTax.TrustShortfallIncome.Amount
    
            ^TRTAMI39 = TRTAMI:RP:TrusteeLiabilities:IncomeTax.TrustExcessOffset.Amount
    
            ^TRTAMI40 = TRTAMI:RP:TrusteeLiabilities:IncomeTax.TrustComponentNotReflected.Amount
    
            ^TRTAMI82 = TRTAMI:RP:StatementOfAttributionDetails:AssessmentDetails:InternationalDealings.AssessableIncomeNonResidentBeneficiary.Amount
            */
            assertion = (report.TRTAMI33 != @"1" && (report.TRTAMI35.GetValueOrDefault() > 0 || report.TRTAMI36.GetValueOrDefault() > 0 || report.TRTAMI39.GetValueOrDefault() > 0 || report.TRTAMI40.GetValueOrDefault() > 0 || (report.RP_StatementOfAttributionDetailsCollection == null ? false : report.RP_StatementOfAttributionDetailsCollection.Any(TRTAMI82Repeat => TRTAMI82Repeat.TRTAMI82.GetValueOrDefault() > 0))));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.TRTAMI.000189",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Is any tax payable by the Trustee?' must be set to ""1"" (payment)",
                    LongDescription = @"When a positive value has been provided for any Trustee Liabilities amounts or any Statement of Attribution (SA) Taxable Determined Member Component amounts, the 'Is any tax payable by the trustee?' must be set to ""1"" (Payment)",
                    Location = "/tns:TRTAMI/tns:RP/tns:OtherReportingInformation/tns:StatementSummaryPaymentRefundOrNilC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRTAMI.000189" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "TRTAMI33", Value = report.TRTAMI33 });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "TRTAMI35", Value = GetValueOrEmpty(report.TRTAMI35) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "TRTAMI36", Value = GetValueOrEmpty(report.TRTAMI36) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "TRTAMI39", Value = GetValueOrEmpty(report.TRTAMI39) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "TRTAMI40", Value = GetValueOrEmpty(report.TRTAMI40) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "TRTAMI82", Value = "TRTAMI82" });

                response.Add(processMessage);
            }
        }
        #endregion

        #region VR.ATO.TRTAMI.000190
        [MethodImpl(MethodImplOptions.AggressiveInlining)]
        public virtual void VRATOTRTAMI000190()
        {
            ProcessMessageDocument processMessage;
            bool assertion;

            /*  VR.ATO.TRTAMI.000190
            If all Trustee Liabilities amounts and all Statement of Attribution (SA) Taxable Determined Member Component amounts are either NULL or zero, then 'Is any tax payable by the trustee?' must be 'no'.

            Technical Business Rule Format:
            ^TRTAMI33 <> '0' AND ((^TRTAMI35 = NULL OR ^TRTAMI35 = 0) AND (^TRTAMI36 = NULL OR ^TRTAMI36 = 0) AND (^TRTAMI39 = NULL OR ^TRTAMI39 = 0) AND (^TRTAMI40 = NULL OR ^TRTAMI40 = 0) AND (AllOccurrences(^TRTAMI82, ^TRTAMI82 = NULL OR ^TRTAMI82 = 0)))
    
            Data Elements:
    
            ^TRTAMI33 = TRTAMI:RP:OtherReportingInformation:Report.Statement.Summary.PaymentRefundOrNil.Code
    
            ^TRTAMI35 = TRTAMI:RP:TrusteeLiabilities:IncomeTax.TrustComponentDeficitOffset.Amount
    
            ^TRTAMI36 = TRTAMI:RP:TrusteeLiabilities:IncomeTax.TrustShortfallIncome.Amount
    
            ^TRTAMI39 = TRTAMI:RP:TrusteeLiabilities:IncomeTax.TrustExcessOffset.Amount
    
            ^TRTAMI40 = TRTAMI:RP:TrusteeLiabilities:IncomeTax.TrustComponentNotReflected.Amount
    
            ^TRTAMI82 = TRTAMI:RP:StatementOfAttributionDetails:AssessmentDetails:InternationalDealings.AssessableIncomeNonResidentBeneficiary.Amount
            */
            assertion = (report.TRTAMI33 != @"0" && ((report.TRTAMI35 == null || report.TRTAMI35 == 0) && (report.TRTAMI36 == null || report.TRTAMI36 == 0) && (report.TRTAMI39 == null || report.TRTAMI39 == 0) && (report.TRTAMI40 == null || report.TRTAMI40 == 0) && (report.RP_StatementOfAttributionDetailsCollection == null ? true : report.RP_StatementOfAttributionDetailsCollection.All(TRTAMI82Repeat => TRTAMI82Repeat.TRTAMI82 == null || TRTAMI82Repeat.TRTAMI82 == 0))));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.TRTAMI.000190",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Is any tax payable by the Trustee?' must be set to ""0"" (Nil)",
                    LongDescription = @"When no positive values have been provided for any Trustee Liabilities amounts or any Statement of Attribution (SA) Taxable Determined Member Component amounts, the 'Is any tax payable by the trustee?' must be set to ""0"" (Nil)",
                    Location = "/tns:TRTAMI/tns:RP/tns:OtherReportingInformation/tns:StatementSummaryPaymentRefundOrNilC",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRTAMI.000190" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "TRTAMI33", Value = report.TRTAMI33 });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "TRTAMI35", Value = GetValueOrEmpty(report.TRTAMI35) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "TRTAMI36", Value = GetValueOrEmpty(report.TRTAMI36) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "TRTAMI39", Value = GetValueOrEmpty(report.TRTAMI39) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "TRTAMI40", Value = GetValueOrEmpty(report.TRTAMI40) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "TRTAMI82", Value = "TRTAMI82" });

                response.Add(processMessage);
            }
        }
        #endregion

        #region VR.ATO.TRTAMI.000291
        [MethodImpl(MethodImplOptions.AggressiveInlining)]
        public virtual void VRATOTRTAMI000291()
        {
            ProcessMessageDocument processMessage;
            bool assertion;

            /*  VR.ATO.TRTAMI.000291
            When the response to Is the Trust Stapled to another Entity? is 'True' (yes), at least one Stapled Entity Australian Business Number must be provided


            Technical Business Rule Format:
                ^TRTAMI112 = TRUE AND AllOccurrences(^TRTAMI139, ^TRTAMI139 = NULL)

            Data Elements:
    
            ^TRTAMI139 = TRTAMI:RP:IncomeTaxStapledEntities:Identifiers.AustralianBusinessNumber.Identifier
    
            ^TRTAMI112 = TRTAMI:RP:IncomeTaxStapledEntities:IncomeTax.AttributionManagedInvestmentTrustStapledStructure.Indicator
            */
            assertion = (report.TRTAMI112 == true && (report.TRTAMI139Collection == null ? true : report.TRTAMI139Collection.All(TRTAMI139Repeat => TRTAMI139Repeat == null)));
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.TRTAMI.000412",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Number of Separate Classes for Trust is invalid",
                    LongDescription = @"When the response to Is the Trust Stapled to another Entity? is 'True' (yes), at least one Stapled Entity Australian Business Number must be provided",
                    Location = "/tns:TRTAMI/tns:RP/tns:IncomeTaxStapledEntities/tns:AustralianBusinessNumberIdCollection/tns:AustralianBusinessNumberId",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.TRTAMI.000291" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "TRTAMI112", Value = GetValueOrEmpty(report.TRTAMI112) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "TRTAMI139", Value = "TRTAMI139" });

                response.Add(processMessage);
            }
        }
        #endregion
    }
}