// ------------------------------------------------------------------------------
//  <auto-generated>
//     This code was generated from a template.
// 
//     Manual changes to this file will be overwritten if the code is regenerated.
//
//     Generated on 2020-02-20T13:41:57, by ESR Version 2.3.0.42 using ESR Database SWS_EA_ESR_Cloud_Prod
//  </auto-generated>
// ------------------------------------------------------------------------------

using System;
using System.Xml;
using System.IO;
using System.Collections.Generic;
using DataContracts;
using System.Text.RegularExpressions;
using System.Reflection;
using System.Linq;
using System.Xml.Schema;
using System.Text;
using System.Net;

namespace Ato.EN.IntegrationServices.CodeGenerationPAYEVNTEMPRequest2020
{
    /// <summary>
    /// XML Consumer for PAYEVNTEMP
    /// </summary>
    public class PAYEVNTEMP2020XmlConsumer
    {
        const string MissingMandatoryMessage = "A mandatory field has not been completed.";
        const string ContactYourProviderMsg = "The message did not pass XML validation. Please contact your software provider.";
        const string InvalidDataValidation = "A field contains invalid data (such as letters in numeric or date field).";
        const string IllFormedXMLMessage = "The logical record or logical document did not pass XML validation. Please contact your software provider.";
        private const string ErrorCode1 = "CMN.ATO.GEN.XML01";
        private const string ErrorCode3 = "CMN.ATO.GEN.XML03";
        private const string ErrorCode4 = "CMN.ATO.GEN.XML04";
        private const string ErrorCode6 = "CMN.ATO.GEN.XML06";
        private const string ErrorCode10 = "CMN.ATO.GEN.XML10";
        private bool _found = false;
        private int _parentCollectionCount;
        private int _childCollectionCount;
        private bool _isExiting = false;
        private bool _isValidationError = false;
        private string _lastPath = string.Empty;
        private ErrorMessageType _validationError = new ErrorMessageType(ErrorDescriptor.NoError);

        #region Error Messages

        public List<ProcessMessageDocument> ErrorMessages { get; set; }

        public bool HasErrors
        {
            get
            {
                return ErrorMessages != null && ErrorMessages.Count > 0;
            }
        }

        private string GetCurrentLocation()
        {
            StringBuilder location = new StringBuilder();
            string[] paths = _currentXPath.ToArray<string>();
            for (int i = paths.Length - 1; i > -1; i--)
            {
                location.Append(paths[i]);
            }
            return location.ToString();
        }

        private void MissingElementError()
        {
            ProcessMessageDocument processMessage;
            processMessage = new ProcessMessageDocument()
            {
                Code = "CMN.ATO.GEN.XML04",
                Description = MissingMandatoryMessage,
                SeverityAsString = "Error",
                Location = GetCurrentLocation(),
            };
            this.ErrorMessages.Add(processMessage);
        }

        #endregion  Error Messages

        #region Embedded Schema

        private static readonly XmlSchemaSet EmbeddedXmlSchemaSet;
        static PAYEVNTEMP2020XmlConsumer()
        {
            Assembly executingAssembly = Assembly.GetExecutingAssembly();
            string[] manifestResourceNames = executingAssembly.GetManifestResourceNames();
            string resourceName;
            Stream embeddedSchemaStream;
            XmlSchema embeddedXmlSchema;

            if (manifestResourceNames != null)
            {
                resourceName = manifestResourceNames.FirstOrDefault(rn => rn.Contains("ato.payevntemp.0004.2020.01.01.xsd") && rn.EndsWith(".xsd"));
                if (resourceName != null)
                {
                    embeddedSchemaStream = executingAssembly.GetManifestResourceStream(resourceName);
                    embeddedXmlSchema = XmlSchema.Read(embeddedSchemaStream, SchemaCallback);
                    EmbeddedXmlSchemaSet = new XmlSchemaSet();
                    EmbeddedXmlSchemaSet.Add(embeddedXmlSchema);
                    EmbeddedXmlSchemaSet.Compile();
                }
            }
        }

        private static void SchemaCallback(object sender, ValidationEventArgs args)
        {
            if (args.Severity == XmlSeverityType.Error)
                throw new XmlSchemaException(args.Message);
        }

        #endregion  Embedded Schema

        #region Xml Reader Settings

        private static XmlReaderSettings ReaderSettings = new XmlReaderSettings()
        {
            CloseInput = false,
            ConformanceLevel = ConformanceLevel.Fragment,
            IgnoreWhitespace = true,
            IgnoreComments = true,
            IgnoreProcessingInstructions = true,
        };

        private XmlReaderSettings GetValidatingReaderSettings()
        {
            XmlReaderSettings validatingReaderSettings = new XmlReaderSettings()
            {
                CloseInput = false,
                ConformanceLevel = ConformanceLevel.Fragment,
                IgnoreWhitespace = true,
                IgnoreComments = true,
                IgnoreProcessingInstructions = true,
                ValidationType = ValidationType.Schema,
            };
            if (EmbeddedXmlSchemaSet == null)
            {
                throw new XmlSchemaException("Embedded Schema is Null");
            }
            else
            {
                validatingReaderSettings.Schemas.Add(EmbeddedXmlSchemaSet);
                validatingReaderSettings.ValidationEventHandler += new ValidationEventHandler(ValidationCallBack);
            }
            return validatingReaderSettings;
        }

        private static Regex DataTypeFailureExpression = new Regex("'(?<Uniqueid>.*?)' element is invalid.*value '(?<Value>.*?)' is invalid.*datatype '(?<DataType>.*?)'", RegexOptions.IgnoreCase | RegexOptions.Compiled | RegexOptions.Singleline);

        private void ValidationCallBack(object sender, ValidationEventArgs args)
        {
            var msg = args.Message;
            var msgToLower = msg.ToLower();
            string lastProcessedElement = string.Empty;

            ProcessMessageDocument processMessage = null;

            if (msgToLower.Contains("invalid according to its datatype"))
            {
                Match match = DataTypeFailureExpression.Match(args.Message);

                if (match.Success && match.Groups.Count == 4)
                {
                    var inner = args.Exception.InnerException;
                    var hint = (inner != null && !string.IsNullOrEmpty(inner.Message)) ? " Hint: " + inner.Message : string.Empty;
                    processMessage = BuildProcessMessageDocument(InvalidDataValidation, string.Empty, ErrorCode3);

                    string uniqueID = match.Groups["Uniqueid"].Value;
                    string value = match.Groups["Value"].Value;
                    string dataType = match.Groups["DataType"].Value;


                    var longDescription = string.Format(@"The value specified for an item does not match the item type (value = ""{0}"", item type = {1}, uniqueID = {2})", value, dataType, uniqueID);
                    processMessage.LongDescription = longDescription + hint;
                    processMessage.Parameters = new ProcessMessageParameters();
                    processMessage.Parameters.Add(new ProcessMessageParameter() { Name = "uniqueID", Value = uniqueID });
                    processMessage.Parameters.Add(new ProcessMessageParameter() { Name = "value", Value = value });
                    processMessage.Parameters.Add(new ProcessMessageParameter() { Name = "dataType", Value = dataType });
                }
            }
            else if (msgToLower.Contains("has incomplete content"))
            {
                _validationError = GetErrorDescriptorForHasIncompleteContent(msg);
                processMessage = BuildProcessMessageDocument(MissingMandatoryMessage, msg + _validationError.Hint, _validationError.Code, "tns:" + _validationError.LastElementProcessed);
                _isValidationError = true;
            }
            else if (msgToLower.Contains("has invalid child element"))
            {
                _validationError = GetErrorDescriptorForHasInvalidChildElement(msg);
                var shortMessage = _validationError.Code == ErrorCode4 ? MissingMandatoryMessage : ContactYourProviderMsg;
                processMessage = BuildProcessMessageDocument(shortMessage, msg + _validationError.Hint, _validationError.Code);
                _isValidationError = true;
            }
            else if (msgToLower.Contains("'xsi:nil' attribute must not be present"))
            {
                processMessage = BuildProcessMessageDocument(ContactYourProviderMsg, msg, ErrorCode1, lastProcessedElement);
                _isValidationError = true;
            }
            else
            {
                processMessage = BuildProcessMessageDocument(ContactYourProviderMsg, msg, ErrorCode1);
                _isValidationError = true;
            }

            this.ErrorMessages.Add(processMessage);
        }

        private ProcessMessageDocument BuildProcessMessageDocument(string shortDescription, string longDescription, string code, string lastElementProcessed)
        {
            return new ProcessMessageDocument()
            {
                Code = code,
                Description = shortDescription,
                LongDescription = longDescription,
                SeverityAsString = "Error",
                Location = lastElementProcessed
            };
        }

        private ProcessMessageDocument BuildProcessMessageDocument(string shortDescription, string longDescription, string code)
        {
            return new ProcessMessageDocument()
            {
                Code = code,
                Description = shortDescription,
                LongDescription = longDescription,
                SeverityAsString = "Error",
                Location = GetCurrentLocation()
            };
        }

        private ProcessMessageDocument BuildProcessMessageDocument(ProcessMessageDocument processMessage, string newLocation)
        {
            return new ProcessMessageDocument()
            {
                Code = processMessage.Code,
                Description = processMessage.Description,
                LongDescription = processMessage.LongDescription,
                SeverityAsString = "Error",
                Location = newLocation
            };
        }

        private enum ErrorDescriptor
        {
            NoError = 0,
            MandatoryElementError,
            NonMandatoryElementError,
            UnknownElement,
            Duplicate
        }

        private struct ErrorMessageType
        {
            public string Hint, Code, ExpectedNextValidElement, LastElementProcessed;
            public ErrorDescriptor Errno;

            public ErrorMessageType(ErrorDescriptor errorDescriptor)
            {
                Errno = errorDescriptor;
                Hint = "";
                Code = "";
                ExpectedNextValidElement = "";
                LastElementProcessed = "";
            }

            public ErrorMessageType(ErrorDescriptor errorDescriptor, string hint, string code, string elementName, string lastElementProcessed)
            {
                Errno = errorDescriptor;
                Hint = hint;
                Code = code;
                ExpectedNextValidElement = elementName;
                LastElementProcessed = lastElementProcessed;
            }
        }

        private ErrorMessageType GetErrorDescriptorForHasIncompleteContent(string validationErrorMessage)
        {
            ErrorMessageType retval = new ErrorMessageType();
            if (string.IsNullOrWhiteSpace(validationErrorMessage)) return retval;

            validationErrorMessage = validationErrorMessage.Replace(" ", string.Empty);
            validationErrorMessage = validationErrorMessage.Replace("'", " ");
            var parts = validationErrorMessage.Split(' ');
            if (parts.Length != 9) return retval;

            var elementBeingProcessed = parts[1];
            var csvList = parts[5];

            retval = ParseHasIncompleteContentCVSList(csvList, elementBeingProcessed);
            return retval;
        }

        private ErrorMessageType GetErrorDescriptorForHasInvalidChildElement(string validationErrorMessage)
        {
            string msg = string.Empty;
            ErrorMessageType retval = new ErrorMessageType();
            if (string.IsNullOrWhiteSpace(validationErrorMessage)) return retval;

            validationErrorMessage = validationErrorMessage.Replace(" ", string.Empty);
            validationErrorMessage = validationErrorMessage.Replace("'", " ");
            var parts = validationErrorMessage.Split(' ');

            //decide which message format to process
            if (validationErrorMessage.ToLower().Contains("listofpossibleelements"))
            {
                if (parts.Length == 13 || parts.Length == 12 || parts.Length == 10)
                {
                    var csvList = parts[9];
                    var elementBeingProcessed = parts[1];
                    var invalidChildElementName = parts[5];
                    retval = ParseCvsListForHasInvalidChildElementLongFormat(csvList, invalidChildElementName, elementBeingProcessed);
                }

                return retval;
            }
            else
            {
                if (parts.Length != 9) return retval;
                var csvList = parts[5];
                var elementBeingProcessed = parts[1];
                var invalidChildElementName = parts[5];

                retval = ParseCvsListForHasInvalidChildElementLongFormat(csvList, invalidChildElementName, elementBeingProcessed);
            }
            return retval;
        }

        private ErrorMessageType ParseCvsListForHasInvalidChildElementShortFormat(string csvList, string invalidChildElementName, string elementBeingProcessed)
        {
            ErrorMessageType retval = new ErrorMessageType();

            if (!string.IsNullOrEmpty(csvList))
            {
                var lastElementInListOfPossibleElements = GetLastElementInCsvList(csvList);

                retval.Hint =
                    string.Format(
                        " Hint: while processing parent element [{0}] child element [{1}] was unexpected",
                        elementBeingProcessed, invalidChildElementName);
                retval.Code = ErrorCode1;
                retval.Errno = ErrorDescriptor.UnknownElement;
                retval.ExpectedNextValidElement = invalidChildElementName;
            }

            return retval;
        }

        private string GetLastElementInCsvList(string csvList)
        {
            var list = (csvList.Contains(','))
                ? new List<string>(csvList.Split(','))
                : new List<string> { csvList };

            string lastElement = list.Last();
            if (lastElement.EndsWith("...."))
            {
                list.RemoveAt(list.Count - 1);
            }

            return list.Last();
        }

        private ErrorMessageType ParseCvsListForHasInvalidChildElementLongFormat(string csvList, string invalidChildElementName, string elementBeingProcessed)
        {
            ErrorMessageType retval = new ErrorMessageType();

            if (!string.IsNullOrEmpty(csvList))
            {
                var lastElementInListOfPossibleElements = GetLastElementInCsvList(csvList);
                var elementList = new List<string>(_elementCsvList.Split(','));

                if (ContainsElementForElementBeingProcessed(elementList, elementBeingProcessed, invalidChildElementName))
                {
                    var indexOfElementBeingProcessed = GetIndexOfElementBeingProcessed(elementList, elementBeingProcessed);
                    var indexOfinvalidChildElementName = GetIndexOfElementUnderElementBeingProcessed(elementList, elementBeingProcessed, invalidChildElementName);
                    var indexOflastElementInListOfPossibleElements = GetIndexOfElementUnderElementBeingProcessed(elementList, elementBeingProcessed, lastElementInListOfPossibleElements);

                    if (indexOfinvalidChildElementName > indexOflastElementInListOfPossibleElements)
                    {
                        retval.Hint =
                            string.Format(
                                " Hint: while processing parent element [{0}] child mandatory element [{1}] was expected but not found",
                                elementBeingProcessed, lastElementInListOfPossibleElements);
                        retval.Code = ErrorCode4;
                        retval.Errno = ErrorDescriptor.MandatoryElementError;
                        retval.ExpectedNextValidElement = lastElementInListOfPossibleElements;
                    }
                    else
                    {
                        retval.Hint =
                            string.Format(
                                " Hint: while processing parent element [{0}] child non mandatory element [{1}] was unexpected",
                                elementBeingProcessed, invalidChildElementName);
                        retval.Code = ErrorCode1;
                        retval.Errno = (indexOfinvalidChildElementName != indexOflastElementInListOfPossibleElements) ? ErrorDescriptor.NonMandatoryElementError : ErrorDescriptor.Duplicate;
                        retval.ExpectedNextValidElement = invalidChildElementName;
                    }
                }
                else
                {
                    //this element is unknown to the schema.
                    retval.Hint =
                        string.Format(
                            " Hint: while processing parent element [{0}] child element [{1}] was unexpected",
                            elementBeingProcessed, invalidChildElementName);
                    retval.Code = ErrorCode1;
                    retval.Errno = ErrorDescriptor.UnknownElement;
                    retval.ExpectedNextValidElement = invalidChildElementName;
                }
            }

            return retval;
        }

        private int GetIndexOfElementUnderElementBeingProcessed(List<string> validElementList,
                                                                string elementBeingProcessed,
                                                                string elementName)
        {
            int result;

            string elementWithParentNameMatch = elementBeingProcessed + "#" + elementName;
            result = validElementList.IndexOf(elementWithParentNameMatch);

            if (result < 0)
            {
                result = validElementList.IndexOf(elementName);
            }

            return result;
        }

        private int GetIndexOfElementBeingProcessed(List<string> validElementList,
                                                    string elementBeingProcessed)
        {
            return validElementList.IndexOf(elementBeingProcessed);
        }

        private bool ContainsElementForElementBeingProcessed(List<string> validElementList,
                                                             string elementBeingProcessed,
                                                             string elementName)
        {
            return validElementList.Contains(elementBeingProcessed + "#" + elementName) || validElementList.Contains(elementName);
        }

        private ErrorMessageType ParseHasIncompleteContentCVSList(string csvList, string elementBeingProcessed)
        {
            ErrorMessageType retval = new ErrorMessageType();

            if (!string.IsNullOrEmpty(csvList))
            {
                var lastElementInListOfPossibleElements = GetLastElementInCsvList(csvList);
                var elementList = new List<string>(_elementCsvList.Split(','));

                retval.Hint =
                    string.Format(
                        " Hint: while processing parent element [{0}] child mandatory element [{1}] was not found",
                        elementBeingProcessed, lastElementInListOfPossibleElements);

                retval.Code = ErrorCode4;
                retval.Errno = ErrorDescriptor.MandatoryElementError;
                retval.ExpectedNextValidElement = lastElementInListOfPossibleElements;
                retval.LastElementProcessed = elementBeingProcessed;
            }
            return retval;
        }

        private void StartEndDateError(DateTime startDate, DateTime endDate)
        {
            ProcessMessageDocument processMessage;

            string longDescription = string.Format("End date is earlier than start date (state date = {0}, end date = {1})", startDate.ToString("yyyy-MM-dd"), endDate.ToString("yyyy-MM-dd"));

            processMessage = new ProcessMessageDocument()
            {
                Code = "CMN.ATO.GEN.XML06",
                Description = "End date is earlier than start date.",
                LongDescription = longDescription,
                SeverityAsString = "Error",
                Location = GetCurrentLocation(),
            };
            processMessage.Parameters = new ProcessMessageParameters();
            processMessage.Parameters.Add(new ProcessMessageParameter() { Name = "startDate", Value = startDate.ToString("yyyy-MM-dd") });
            processMessage.Parameters.Add(new ProcessMessageParameter() { Name = "endDate", Value = endDate.ToString("yyyy-MM-dd") });
            this.ErrorMessages.Add(processMessage);
        }

        private void StartEndDateError(DateTime? startDate, DateTime? endDate)
        {
            ProcessMessageDocument processMessage;

            if (startDate == null || endDate == null)
                return;

            string longDescription = string.Format("End date is earlier than start date (state date = {0}, end date = {1})", startDate.Value.ToString("yyyy-MM-dd"), endDate.Value.ToString("yyyy-MM-dd"));

            processMessage = new ProcessMessageDocument()
            {
                Code = "CMN.ATO.GEN.XML06",
                Description = "End date is earlier than start date.",
                LongDescription = longDescription,
                SeverityAsString = "Error",
                Location = GetCurrentLocation(),
            };
            processMessage.Parameters = new ProcessMessageParameters();
            processMessage.Parameters.Add(new ProcessMessageParameter() { Name = "startDate", Value = startDate.Value.ToString("yyyy-MM-dd") });
            processMessage.Parameters.Add(new ProcessMessageParameter() { Name = "endDate", Value = endDate.Value.ToString("yyyy-MM-dd") });
            this.ErrorMessages.Add(processMessage);
        }

        #endregion  Xml Reader Settings

        #region IsEmptyOrNilElement
        private static bool IsEmptyOrNilElement(XmlReader reader)
        {
            bool emptyOrNil = false;
            if (reader.IsEmptyElement)
            {
                emptyOrNil = true;
            }
            else
            {
                if (reader.HasAttributes)
                {
                    string nilValue = reader.GetAttribute("nil", "http://www.w3.org/2001/XMLSchema-instance");
                    if (nilValue != null && nilValue.ToLowerInvariant() == "true" || nilValue == "1")
                    {
                        emptyOrNil = true;
                    }
                }
            }
            return emptyOrNil;
        }
        #endregion  IsEmptyOrNilElement

        #region ToBoolean
        private bool? ToBoolean(string str)
        {
            bool returnValue;
            string value = (str ?? "").Trim();
            if (value == "0" || value == "1")
                return Convert.ToBoolean(Convert.ToInt32(value));

            if (Boolean.TryParse(value, out returnValue))
                return returnValue;
            return null;
        }
        #endregion  ToBoolean

        #region MoveToContent
        public bool MoveToContent(XmlReader reader)
        {
            try
            {
                reader.MoveToContent();
                return true;
            }
            catch (XmlException ex)
            {
                ProcessMessageDocument processMessage;
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.GEN.XML01",
                    Description = ContactYourProviderMsg,
                    LongDescription = ex.Message,
                    SeverityAsString = "Error",
                };
                this.ErrorMessages.Add(processMessage);
                return false;
            }
        }
        #endregion  MoveToContent

        #region ReadToNextElement


        public bool ReadToNextElement(XmlReader reader, bool isMandatory)
        {
            return ReadToNextElement(reader);
        }

        public bool ReadToNextElement(XmlReader reader)
        {
            bool retval = false;

            if ((reader.EOF && !_isValidationError) || _isExiting)
            {
                return false; //do nothing
            }

            if (!_isValidationError)
            {
                retval = SetReaderToNextElement(reader); //position the reader on the next valid element
            }

            if (_isValidationError)
            {
                //process validation errors
                var expectedNextElement = (!string.IsNullOrEmpty(_validationError.ExpectedNextValidElement)) ? _validationError.ExpectedNextValidElement : reader.LocalName;
                var actualNextValidElement = reader.LocalName;
                var location = GetCurrentLocation();

                if (_validationError.Errno == ErrorDescriptor.Duplicate)
                {
                    location = _lastPath;
                }

                var xpath = RemoveLeadingAndTrailingSlashes(location);

                var element = GetElementDescriptor(xpath);

                if (_validationError.Errno == ErrorDescriptor.UnknownElement)
                {
                    //set the xpath for elements that are not known to the schema
                    location = "/" + element.Path + "/" + element.Prefix + ":" + _validationError.ExpectedNextValidElement;
                    _isExiting = true;
                }
                else if (_validationError.Errno == ErrorDescriptor.NonMandatoryElementError)
                {
                    //set the xpath for the optional element that caused a validation
                    location = "/" + element.Path + "/" + element.Prefix + ":" + reader.LocalName;
                    _isExiting = true;
                }
                else
                {
                    //decide if we have spooled to the missing mandatory element. 
                    _isExiting = expectedNextElement == element.PathLeafNode;
                }

                if (_isExiting)
                {
                    //The location has changed since detection of the validation error - so update it.
                    UpdateErrorMessageWithLocation(location);
                }

                return false;
            }

            //Save previous path so we can detect duplicate elements
            _lastPath = GetCurrentLocation();

            return retval;
        }

        private bool ReadNext(XmlReader reader)
        {
            return !reader.EOF && reader.Read();
        }

        private void UpdateErrorMessageWithLocation(string newLocation)
        {
            var lastProcessMessage = ErrorMessages.Last();
            ErrorMessages.Remove(lastProcessMessage);
            var newProcessMessage = BuildProcessMessageDocument(lastProcessMessage, newLocation);
            ErrorMessages.Add(newProcessMessage);
        }

        private string RemoveLeadingAndTrailingSlashes(string xpath)
        {
            var xpathLength = xpath.Length;
            if (xpathLength <= 0) return string.Empty;
            var firstChar = xpath.Substring(0, 1);
            var lastChar = xpath.Substring(xpathLength - 1, 1);
            if (firstChar == "/")
            {
                xpath = xpath.Remove(0, 1);
                xpathLength--;
            }
            if (lastChar == "/")
            {
                xpath = xpath.Remove(xpathLength - 1, 1);
            }
            return xpath;
        }

        private struct ElementDescriptor
        {
            public string Prefix, PathLeafNode, Path;
            public ElementDescriptor(string prefix, string leaf, string path)
            {
                Prefix = prefix;
                PathLeafNode = leaf;
                Path = path;
            }
        }

        private ElementDescriptor GetElementDescriptor(string xpath)
        {
            var retval = new ElementDescriptor();

            var parts = xpath.Split('/');
            var numberOfParts = parts.Length;
            if (numberOfParts > 0)
            {
                var leafNode = parts[numberOfParts - 1];
                var p = leafNode.Split(':');
                numberOfParts = p.Length;
                if (numberOfParts == 1)
                {
                    retval.PathLeafNode = p[0];
                    retval.Prefix = string.Empty;
                }
                else if (numberOfParts == 2)
                {
                    retval.PathLeafNode = p[1];
                    retval.Prefix = p[0];
                }
                var leafNodeLength = leafNode.Length;
                var path = xpath.Remove(xpath.Length - leafNodeLength, leafNodeLength);
                retval.Path = RemoveLeadingAndTrailingSlashes(path);
            }
            return retval;
        }

        private bool SetReaderToNextElement(XmlReader reader)
        {
            try
            {
                if (reader.EOF || _isExiting) return false;
                if (_found)
                {
                    reader.Read();
                    _found = false;
                }
                while (!reader.EOF && reader.NodeType != XmlNodeType.Element)
                {
                    reader.Read();
                }

                return reader.NodeType == XmlNodeType.Element && !reader.EOF;

            }
            catch (XmlException ex)
            {
                ProcessMessageDocument processMessage;
                processMessage = new ProcessMessageDocument()
                {
                    Code = ErrorCode1,
                    Description = ContactYourProviderMsg,
                    LongDescription = ex.Message,
                    SeverityAsString = "Error",
                };
                this.ErrorMessages.Add(processMessage);
                return false;
            }
        }

        #endregion  ReadToNextElement

        private Stack<string> _currentXPath = new Stack<string>();

        public PAYEVNTEMP2020 Consume(Stream streamToLoad, bool validateDataTypes = false)
        {
            PAYEVNTEMP2020 report = new PAYEVNTEMP2020();

            // Working Variable for if can still read from the xml stream
            bool reading;

            // Working Variables for current values
            string currentValue;
            DateTime currentDateTimeValue;
            bool? currentBooleanValue;
            decimal currentDecimalValue;
            double currentDoubleValue;
            float currentFloatValue;
            sbyte currentsByteValue;
            byte currentByteValue;
            short currentShortValue;
            ushort currentuShortValue;
            uint currentuIntValue;
            int currentIntValue;
            long currentLongValue;
            ulong currentuLongValue;

            this.ErrorMessages = new List<ProcessMessageDocument>();
            _currentXPath.Push("/tns:PAYEVNTEMP");

            if (streamToLoad == null || streamToLoad.Length == 0 || !streamToLoad.CanRead)
            {
                MissingElementError();
                return report;
            }

            streamToLoad.Position = 0;
            XmlReader reader;

            if (validateDataTypes)
                reader = XmlReader.Create(streamToLoad, GetValidatingReaderSettings());
            else
                reader = XmlReader.Create(streamToLoad, ReaderSettings);

            if (!MoveToContent(reader))
                return report;

            reading = !reader.EOF;

            if (ReadToNextElement(reader) && reader.LocalName == "PAYEVNTEMP" && reader.NamespaceURI == "http://www.sbr.gov.au/ato/payevntemp")
            {
                _found = true;
                ReadToNextElement(reader);
            }
            else
            {
                MissingElementError();
                return report;
            }


            #region Payee
            _currentXPath.Push("/tns:Payee");
            //3. use case
            if (ReadToNextElement(reader,true) && reader.LocalName == "Payee")
            {
                report.PayeeCollectionExists = true;
                report.PayeeCollectionCount += 1;
                _found = true; 
        
                #region Identifiers
                _currentXPath.Push("/tns:Identifiers");
                //3. use case
                if (ReadToNextElement(reader,true) && reader.LocalName == "Identifiers")
                {
                    report.Payee_IdentifiersCollectionExists = true;
                    report.Payee_IdentifiersCollectionCount += 1;
                    _found = true; 
            
                    #region TaxFileNumberId
                    _currentXPath.Push("/tns:TaxFileNumberId");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "TaxFileNumberId")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                report.PAYEVNTEMP13 = currentValue;
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion TaxFileNumberId
            
                    #region AustralianBusinessNumberId
                    _currentXPath.Push("/tns:AustralianBusinessNumberId");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "AustralianBusinessNumberId")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                report.PAYEVNTEMP91 = currentValue;
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion AustralianBusinessNumberId
            
                    #region EmploymentPayrollNumberId
                    _currentXPath.Push("/tns:EmploymentPayrollNumberId");
                    //6. use case
                    if (ReadToNextElement(reader,true) && reader.LocalName == "EmploymentPayrollNumberId")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                report.PAYEVNTEMP11 = currentValue;
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion EmploymentPayrollNumberId
            
                    #region PreviousPayrollIDEmploymentPayrollNumberId
                    _currentXPath.Push("/tns:PreviousPayrollIDEmploymentPayrollNumberId");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "PreviousPayrollIDEmploymentPayrollNumberId")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                report.PAYEVNTEMP251 = currentValue;
                                report.Payee_Identifiers_PreviousPayrollIDCollectionExists = true;
                                report.Payee_Identifiers_PreviousPayrollIDCollectionCount += 1;
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion PreviousPayrollIDEmploymentPayrollNumberId
                } // End of if Identifiers node exists
        
                _currentXPath.Pop();
                #endregion Identifiers
        
                #region PersonNameDetails
                _currentXPath.Push("/tns:PersonNameDetails");
                //3. use case
                if (ReadToNextElement(reader,true) && reader.LocalName == "PersonNameDetails")
                {
                    report.Payee_PersonNameDetailsCollectionExists = true;
                    report.Payee_PersonNameDetailsCollectionCount += 1;
                    _found = true; 
            
                    #region FamilyNameT
                    _currentXPath.Push("/tns:FamilyNameT");
                    //6. use case
                    if (ReadToNextElement(reader,true) && reader.LocalName == "FamilyNameT")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                report.PAYEVNTEMP15 = currentValue;
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion FamilyNameT
            
                    #region GivenNameT
                    _currentXPath.Push("/tns:GivenNameT");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "GivenNameT")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                report.PAYEVNTEMP16 = currentValue;
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion GivenNameT
            
                    #region OtherGivenNameT
                    _currentXPath.Push("/tns:OtherGivenNameT");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "OtherGivenNameT")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                report.PAYEVNTEMP17 = currentValue;
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion OtherGivenNameT
                } // End of if PersonNameDetails node exists
        
                _currentXPath.Pop();
                #endregion PersonNameDetails
        
                #region PersonDemographicDetailsBirth
                _currentXPath.Push("/tns:PersonDemographicDetailsBirth");
                //3. use case
                if (ReadToNextElement(reader,false) && reader.LocalName == "PersonDemographicDetailsBirth")
                {
                    report.Payee_PersonDemographicDetailsBirthCollectionExists = true;
                    report.Payee_PersonDemographicDetailsBirthCollectionCount += 1;
                    _found = true; 
            
                    #region Dm
                    _currentXPath.Push("/tns:Dm");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "Dm")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                if (Int32.TryParse(currentValue, out currentIntValue))
                                {
                                    report.PAYEVNTEMP205 = currentIntValue;
                                }
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion Dm
            
                    #region M
                    _currentXPath.Push("/tns:M");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "M")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                if (Int32.TryParse(currentValue, out currentIntValue))
                                {
                                    report.PAYEVNTEMP203 = currentIntValue;
                                }
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion M
            
                    #region Y
                    _currentXPath.Push("/tns:Y");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "Y")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                if (Int32.TryParse(currentValue, out currentIntValue))
                                {
                                    report.PAYEVNTEMP204 = currentIntValue;
                                }
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion Y
                } // End of if PersonDemographicDetailsBirth node exists
        
                _currentXPath.Pop();
                #endregion PersonDemographicDetailsBirth
        
                #region AddressDetails
                _currentXPath.Push("/tns:AddressDetails");
                //3. use case
                if (ReadToNextElement(reader,true) && reader.LocalName == "AddressDetails")
                {
                    report.Payee_AddressDetailsCollectionExists = true;
                    report.Payee_AddressDetailsCollectionCount += 1;
                    _found = true; 
            
                    #region Line1T
                    _currentXPath.Push("/tns:Line1T");
                    //6. use case
                    if (ReadToNextElement(reader,true) && reader.LocalName == "Line1T")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                report.PAYEVNTEMP21 = currentValue;
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion Line1T
            
                    #region Line2T
                    _currentXPath.Push("/tns:Line2T");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "Line2T")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                report.PAYEVNTEMP22 = currentValue;
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion Line2T
            
                    #region LocalityNameT
                    _currentXPath.Push("/tns:LocalityNameT");
                    //6. use case
                    if (ReadToNextElement(reader,true) && reader.LocalName == "LocalityNameT")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                report.PAYEVNTEMP23 = currentValue;
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion LocalityNameT
            
                    #region StateOrTerritoryC
                    _currentXPath.Push("/tns:StateOrTerritoryC");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "StateOrTerritoryC")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                report.PAYEVNTEMP24 = currentValue;
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion StateOrTerritoryC
            
                    #region PostcodeT
                    _currentXPath.Push("/tns:PostcodeT");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "PostcodeT")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                report.PAYEVNTEMP25 = currentValue;
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion PostcodeT
            
                    #region CountryC
                    _currentXPath.Push("/tns:CountryC");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "CountryC")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                report.PAYEVNTEMP27 = currentValue;
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion CountryC
                } // End of if AddressDetails node exists
        
                _currentXPath.Pop();
                #endregion AddressDetails
        
                #region ElectronicContact
                _currentXPath.Push("/tns:ElectronicContact");
                //3. use case
                if (ReadToNextElement(reader,false) && reader.LocalName == "ElectronicContact")
                {
                    report.Payee_ElectronicContactCollectionExists = true;
                    report.Payee_ElectronicContactCollectionCount += 1;
                    _found = true; 
            
                    #region ElectronicMailAddressT
                    _currentXPath.Push("/tns:ElectronicMailAddressT");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "ElectronicMailAddressT")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                report.PAYEVNTEMP94 = currentValue;
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion ElectronicMailAddressT
            
                    #region TelephoneMinimalN
                    _currentXPath.Push("/tns:TelephoneMinimalN");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "TelephoneMinimalN")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                report.PAYEVNTEMP95 = currentValue;
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion TelephoneMinimalN
                } // End of if ElectronicContact node exists
        
                _currentXPath.Pop();
                #endregion ElectronicContact
        
                #region EmployerConditions
                _currentXPath.Push("/tns:EmployerConditions");
                //3. use case
                if (ReadToNextElement(reader,false) && reader.LocalName == "EmployerConditions")
                {
                    report.Payee_EmployerConditionsCollectionExists = true;
                    report.Payee_EmployerConditionsCollectionCount += 1;
                    _found = true; 
            
                    #region EmploymentStartD
                    _currentXPath.Push("/tns:EmploymentStartD");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "EmploymentStartD")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                if (DateTime.TryParse(currentValue, out currentDateTimeValue))
                                {
                                    report.PAYEVNTEMP92 = currentDateTimeValue.Date;
                                }
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion EmploymentStartD
            
                    #region EmploymentEndD
                    _currentXPath.Push("/tns:EmploymentEndD");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "EmploymentEndD")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                if (DateTime.TryParse(currentValue, out currentDateTimeValue))
                                {
                                    report.PAYEVNTEMP93 = currentDateTimeValue.Date;
                                }
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion EmploymentEndD
            
                    #region PaymentBasisC
                    _currentXPath.Push("/tns:PaymentBasisC");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "PaymentBasisC")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                report.PAYEVNTEMP282 = currentValue;
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion PaymentBasisC
            
                    #region CessationTypeC
                    _currentXPath.Push("/tns:CessationTypeC");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "CessationTypeC")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                report.PAYEVNTEMP253 = currentValue;
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion CessationTypeC
            
                    #region TaxTreatmentC
                    _currentXPath.Push("/tns:TaxTreatmentC");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "TaxTreatmentC")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                report.PAYEVNTEMP254 = currentValue;
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion TaxTreatmentC
            
                    #region TaxOffsetClaimTotalA
                    _currentXPath.Push("/tns:TaxOffsetClaimTotalA");
                    //6. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "TaxOffsetClaimTotalA")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                if (Decimal.TryParse(currentValue, out currentDecimalValue))
                                {
                                    report.PAYEVNTEMP255 = currentDecimalValue;
                                }
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion TaxOffsetClaimTotalA
                } // End of if EmployerConditions node exists
        
                _currentXPath.Pop();
                #endregion EmployerConditions
        
                #region PayrollPeriod
                _currentXPath.Push("/tns:PayrollPeriod");
                //3. use case
                if (ReadToNextElement(reader,true) && reader.LocalName == "PayrollPeriod")
                {
                    report.Payee_PayrollPeriodCollectionExists = true;
                    report.Payee_PayrollPeriodCollectionCount += 1;
                    _found = true; 
            
                    #region StartD
                    _currentXPath.Push("/tns:StartD");
                    //6. use case
                    if (ReadToNextElement(reader,true) && reader.LocalName == "StartD")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                if (DateTime.TryParse(currentValue, out currentDateTimeValue))
                                {
                                    report.PAYEVNTEMP29 = currentDateTimeValue.Date;
                                }
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion StartD
            
                    #region EndD
                    _currentXPath.Push("/tns:EndD");
                    //6. use case
                    if (ReadToNextElement(reader,true) && reader.LocalName == "EndD")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                if (DateTime.TryParse(currentValue, out currentDateTimeValue))
                                {
                                    report.PAYEVNTEMP30 = currentDateTimeValue.Date;
                                }
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion EndD
            
                    #region RemunerationPayrollEventFinalI
                    _currentXPath.Push("/tns:RemunerationPayrollEventFinalI");
                    //6. use case
                    if (ReadToNextElement(reader,true) && reader.LocalName == "RemunerationPayrollEventFinalI")
                    {
                        if (!IsEmptyOrNilElement(reader))
                        {
                            ReadNext(reader);
                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                            {
                                currentValue = reader.Value;
                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                currentBooleanValue = ToBoolean(currentValue);
                                if (currentBooleanValue != null)
                                {
                                    report.PAYEVNTEMP110 = currentBooleanValue;
                                }
                            }
                        }
                        _found = true;
                    }
            
                    _currentXPath.Pop();
                    #endregion RemunerationPayrollEventFinalI
            
                    #region Remuneration
            
                    _currentXPath.Push("/tns:RemunerationCollection");
                    // 4. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "RemunerationCollection")
                    {
                        report.Payee_PayrollPeriod_RemunerationCollection = new List<PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration>();
                        report.Payee_PayrollPeriod_RemunerationCollectionExists = true;
            
                        _found = true;
            
                        while ( ReadToNextElement(reader,false) && reader.LocalName == "Remuneration" ) 
                        {
                            _found = true;
            
                            PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration remuneration = new PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration();
                            report.Payee_PayrollPeriod_RemunerationCollection.Add(remuneration);
                            report.Payee_PayrollPeriod_RemunerationCollectionCount += 1;
                            remuneration.OccurrenceIndex = report.Payee_PayrollPeriod_RemunerationCollectionCount;
            
                            _currentXPath.Push("/tns:Remuneration[" + report.Payee_PayrollPeriod_RemunerationCollectionCount + "]");
                    
                            #region IncomeStreamTypeC
                            _currentXPath.Push("/tns:IncomeStreamTypeC");
                            //6. use case
                            if (ReadToNextElement(reader,true) && reader.LocalName == "IncomeStreamTypeC")
                            {
                                if (!IsEmptyOrNilElement(reader))
                                {
                                    ReadNext(reader);
                                    if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                    {
                                        currentValue = reader.Value;
                                        ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                        remuneration.PAYEVNTEMP257 = currentValue;
                                    }
                                }
                                _found = true;
                            }
                    
                            _currentXPath.Pop();
                            #endregion IncomeStreamTypeC
                    
                            #region AddressDetailsCountryC
                            _currentXPath.Push("/tns:AddressDetailsCountryC");
                            //6. use case
                            if (ReadToNextElement(reader,false) && reader.LocalName == "AddressDetailsCountryC")
                            {
                                if (!IsEmptyOrNilElement(reader))
                                {
                                    ReadNext(reader);
                                    if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                    {
                                        currentValue = reader.Value;
                                        ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                        remuneration.PAYEVNTEMP260 = currentValue;
                                    }
                                }
                                _found = true;
                            }
                    
                            _currentXPath.Pop();
                            #endregion AddressDetailsCountryC
                    
                            #region IncomeTaxPayAsYouGoWithholdingTaxWithheldA
                            _currentXPath.Push("/tns:IncomeTaxPayAsYouGoWithholdingTaxWithheldA");
                            //6. use case
                            if (ReadToNextElement(reader,false) && reader.LocalName == "IncomeTaxPayAsYouGoWithholdingTaxWithheldA")
                            {
                                if (!IsEmptyOrNilElement(reader))
                                {
                                    ReadNext(reader);
                                    if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                    {
                                        currentValue = reader.Value;
                                        ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                        if (Decimal.TryParse(currentValue, out currentDecimalValue))
                                        {
                                            remuneration.PAYEVNTEMP259 = currentDecimalValue;
                                        }
                                    }
                                }
                                _found = true;
                            }
                    
                            _currentXPath.Pop();
                            #endregion IncomeTaxPayAsYouGoWithholdingTaxWithheldA
                    
                            #region IncomeTaxForeignWithholdingA
                            _currentXPath.Push("/tns:IncomeTaxForeignWithholdingA");
                            //6. use case
                            if (ReadToNextElement(reader,false) && reader.LocalName == "IncomeTaxForeignWithholdingA")
                            {
                                if (!IsEmptyOrNilElement(reader))
                                {
                                    ReadNext(reader);
                                    if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                    {
                                        currentValue = reader.Value;
                                        ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                        if (Decimal.TryParse(currentValue, out currentDecimalValue))
                                        {
                                            remuneration.PAYEVNTEMP278 = currentDecimalValue;
                                        }
                                    }
                                }
                                _found = true;
                            }
                    
                            _currentXPath.Pop();
                            #endregion IncomeTaxForeignWithholdingA
                    
                            #region IndividualNonBusinessExemptForeignEmploymentIncomeA
                            _currentXPath.Push("/tns:IndividualNonBusinessExemptForeignEmploymentIncomeA");
                            //6. use case
                            if (ReadToNextElement(reader,false) && reader.LocalName == "IndividualNonBusinessExemptForeignEmploymentIncomeA")
                            {
                                if (!IsEmptyOrNilElement(reader))
                                {
                                    ReadNext(reader);
                                    if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                    {
                                        currentValue = reader.Value;
                                        ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                        if (Decimal.TryParse(currentValue, out currentDecimalValue))
                                        {
                                            remuneration.PAYEVNTEMP261 = currentDecimalValue;
                                        }
                                    }
                                }
                                _found = true;
                            }
                    
                            _currentXPath.Pop();
                            #endregion IndividualNonBusinessExemptForeignEmploymentIncomeA
                    
                            #region GrossA
                            _currentXPath.Push("/tns:GrossA");
                            //6. use case
                            if (ReadToNextElement(reader,false) && reader.LocalName == "GrossA")
                            {
                                if (!IsEmptyOrNilElement(reader))
                                {
                                    ReadNext(reader);
                                    if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                    {
                                        currentValue = reader.Value;
                                        ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                        if (Decimal.TryParse(currentValue, out currentDecimalValue))
                                        {
                                            remuneration.PAYEVNTEMP258 = currentDecimalValue;
                                        }
                                    }
                                }
                                _found = true;
                            }
                    
                            _currentXPath.Pop();
                            #endregion GrossA
                    
                            #region PaidLeave
                    
                            _currentXPath.Push("/tns:PaidLeaveCollection");
                            // 4. use case
                            if (ReadToNextElement(reader,false) && reader.LocalName == "PaidLeaveCollection")
                            {
                                remuneration.Payee_PayrollPeriod_Remuneration_PaidLeaveCollection = new List<PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_PaidLeave>();
                                remuneration.Payee_PayrollPeriod_Remuneration_PaidLeaveCollectionExists = true;
                    
                                _found = true;
                    
                                while ( ReadToNextElement(reader,false) && reader.LocalName == "PaidLeave" ) 
                                {
                                    _found = true;
                    
                                    PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_PaidLeave paidLeave = new PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_PaidLeave();
                                    remuneration.Payee_PayrollPeriod_Remuneration_PaidLeaveCollection.Add(paidLeave);
                                    remuneration.Payee_PayrollPeriod_Remuneration_PaidLeaveCollectionCount += 1;
                                    paidLeave.OccurrenceIndex = remuneration.Payee_PayrollPeriod_Remuneration_PaidLeaveCollectionCount;
                    
                                    _currentXPath.Push("/tns:PaidLeave[" + remuneration.Payee_PayrollPeriod_Remuneration_PaidLeaveCollectionCount + "]");
                            
                                    #region TypeC
                                    _currentXPath.Push("/tns:TypeC");
                                    //6. use case
                                    if (ReadToNextElement(reader,true) && reader.LocalName == "TypeC")
                                    {
                                        if (!IsEmptyOrNilElement(reader))
                                        {
                                            ReadNext(reader);
                                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                            {
                                                currentValue = reader.Value;
                                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                                paidLeave.PAYEVNTEMP269 = currentValue;
                                            }
                                        }
                                        _found = true;
                                    }
                            
                                    _currentXPath.Pop();
                                    #endregion TypeC
                            
                                    #region PaymentA
                                    _currentXPath.Push("/tns:PaymentA");
                                    //6. use case
                                    if (ReadToNextElement(reader,true) && reader.LocalName == "PaymentA")
                                    {
                                        if (!IsEmptyOrNilElement(reader))
                                        {
                                            ReadNext(reader);
                                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                            {
                                                currentValue = reader.Value;
                                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                                if (Decimal.TryParse(currentValue, out currentDecimalValue))
                                                {
                                                    paidLeave.PAYEVNTEMP270 = currentDecimalValue;
                                                }
                                            }
                                        }
                                        _found = true;
                                    }
                            
                                    _currentXPath.Pop();
                                    #endregion PaymentA
                                _currentXPath.Pop();
                                } // End of while loop for PaidLeave
                            } // End of if PaidLeaveCollection node exists
                    
                            _currentXPath.Pop();
                            #endregion PaidLeave
                    
                            #region Allowance
                    
                            _currentXPath.Push("/tns:AllowanceCollection");
                            // 4. use case
                            if (ReadToNextElement(reader,false) && reader.LocalName == "AllowanceCollection")
                            {
                                remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollection = new List<PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_Allowance>();
                                remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollectionExists = true;
                    
                                _found = true;
                    
                                while ( ReadToNextElement(reader,false) && reader.LocalName == "Allowance" ) 
                                {
                                    _found = true;
                    
                                    PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_Allowance allowance = new PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_Allowance();
                                    remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollection.Add(allowance);
                                    remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollectionCount += 1;
                                    allowance.OccurrenceIndex = remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollectionCount;
                    
                                    _currentXPath.Push("/tns:Allowance[" + remuneration.Payee_PayrollPeriod_Remuneration_AllowanceCollectionCount + "]");
                            
                                    #region TypeC
                                    _currentXPath.Push("/tns:TypeC");
                                    //6. use case
                                    if (ReadToNextElement(reader,true) && reader.LocalName == "TypeC")
                                    {
                                        if (!IsEmptyOrNilElement(reader))
                                        {
                                            ReadNext(reader);
                                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                            {
                                                currentValue = reader.Value;
                                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                                allowance.PAYEVNTEMP7 = currentValue;
                                            }
                                        }
                                        _found = true;
                                    }
                            
                                    _currentXPath.Pop();
                                    #endregion TypeC
                            
                                    #region OtherAllowanceTypeDe
                                    _currentXPath.Push("/tns:OtherAllowanceTypeDe");
                                    //6. use case
                                    if (ReadToNextElement(reader,false) && reader.LocalName == "OtherAllowanceTypeDe")
                                    {
                                        if (!IsEmptyOrNilElement(reader))
                                        {
                                            ReadNext(reader);
                                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                            {
                                                currentValue = reader.Value;
                                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                                allowance.PAYEVNTEMP8 = currentValue;
                                            }
                                        }
                                        _found = true;
                                    }
                            
                                    _currentXPath.Pop();
                                    #endregion OtherAllowanceTypeDe
                            
                                    #region EmploymentAllowancesA
                                    _currentXPath.Push("/tns:EmploymentAllowancesA");
                                    //6. use case
                                    if (ReadToNextElement(reader,true) && reader.LocalName == "EmploymentAllowancesA")
                                    {
                                        if (!IsEmptyOrNilElement(reader))
                                        {
                                            ReadNext(reader);
                                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                            {
                                                currentValue = reader.Value;
                                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                                if (Decimal.TryParse(currentValue, out currentDecimalValue))
                                                {
                                                    allowance.PAYEVNTEMP62 = currentDecimalValue;
                                                }
                                            }
                                        }
                                        _found = true;
                                    }
                            
                                    _currentXPath.Pop();
                                    #endregion EmploymentAllowancesA
                                _currentXPath.Pop();
                                } // End of while loop for Allowance
                            } // End of if AllowanceCollection node exists
                    
                            _currentXPath.Pop();
                            #endregion Allowance
                    
                            #region OvertimePaymentA
                            _currentXPath.Push("/tns:OvertimePaymentA");
                            //6. use case
                            if (ReadToNextElement(reader,false) && reader.LocalName == "OvertimePaymentA")
                            {
                                if (!IsEmptyOrNilElement(reader))
                                {
                                    ReadNext(reader);
                                    if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                    {
                                        currentValue = reader.Value;
                                        ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                        if (Decimal.TryParse(currentValue, out currentDecimalValue))
                                        {
                                            remuneration.PAYEVNTEMP263 = currentDecimalValue;
                                        }
                                    }
                                }
                                _found = true;
                            }
                    
                            _currentXPath.Pop();
                            #endregion OvertimePaymentA
                    
                            #region GrossBonusesAndCommissionsA
                            _currentXPath.Push("/tns:GrossBonusesAndCommissionsA");
                            //6. use case
                            if (ReadToNextElement(reader,false) && reader.LocalName == "GrossBonusesAndCommissionsA")
                            {
                                if (!IsEmptyOrNilElement(reader))
                                {
                                    ReadNext(reader);
                                    if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                    {
                                        currentValue = reader.Value;
                                        ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                        if (Decimal.TryParse(currentValue, out currentDecimalValue))
                                        {
                                            remuneration.PAYEVNTEMP262 = currentDecimalValue;
                                        }
                                    }
                                }
                                _found = true;
                            }
                    
                            _currentXPath.Pop();
                            #endregion GrossBonusesAndCommissionsA
                    
                            #region GrossDirectorsFeesA
                            _currentXPath.Push("/tns:GrossDirectorsFeesA");
                            //6. use case
                            if (ReadToNextElement(reader,false) && reader.LocalName == "GrossDirectorsFeesA")
                            {
                                if (!IsEmptyOrNilElement(reader))
                                {
                                    ReadNext(reader);
                                    if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                    {
                                        currentValue = reader.Value;
                                        ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                        if (Decimal.TryParse(currentValue, out currentDecimalValue))
                                        {
                                            remuneration.PAYEVNTEMP264 = currentDecimalValue;
                                        }
                                    }
                                }
                                _found = true;
                            }
                    
                            _currentXPath.Pop();
                            #endregion GrossDirectorsFeesA
                    
                            #region IndividualNonBusinessCommunityDevelopmentEmploymentProjectA
                            _currentXPath.Push("/tns:IndividualNonBusinessCommunityDevelopmentEmploymentProjectA");
                            //6. use case
                            if (ReadToNextElement(reader,false) && reader.LocalName == "IndividualNonBusinessCommunityDevelopmentEmploymentProjectA")
                            {
                                if (!IsEmptyOrNilElement(reader))
                                {
                                    ReadNext(reader);
                                    if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                    {
                                        currentValue = reader.Value;
                                        ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                        if (Decimal.TryParse(currentValue, out currentDecimalValue))
                                        {
                                            remuneration.PAYEVNTEMP279 = currentDecimalValue;
                                        }
                                    }
                                }
                                _found = true;
                            }
                    
                            _currentXPath.Pop();
                            #endregion IndividualNonBusinessCommunityDevelopmentEmploymentProjectA
                    
                            #region SalarySacrifice
                    
                            _currentXPath.Push("/tns:SalarySacrificeCollection");
                            // 4. use case
                            if (ReadToNextElement(reader,false) && reader.LocalName == "SalarySacrificeCollection")
                            {
                                remuneration.Payee_PayrollPeriod_Remuneration_SalarySacrificeCollection = new List<PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_SalarySacrifice>();
                                remuneration.Payee_PayrollPeriod_Remuneration_SalarySacrificeCollectionExists = true;
                    
                                _found = true;
                    
                                while ( ReadToNextElement(reader,false) && reader.LocalName == "SalarySacrifice" ) 
                                {
                                    _found = true;
                    
                                    PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_SalarySacrifice salarySacrifice = new PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_SalarySacrifice();
                                    remuneration.Payee_PayrollPeriod_Remuneration_SalarySacrificeCollection.Add(salarySacrifice);
                                    remuneration.Payee_PayrollPeriod_Remuneration_SalarySacrificeCollectionCount += 1;
                                    salarySacrifice.OccurrenceIndex = remuneration.Payee_PayrollPeriod_Remuneration_SalarySacrificeCollectionCount;
                    
                                    _currentXPath.Push("/tns:SalarySacrifice[" + remuneration.Payee_PayrollPeriod_Remuneration_SalarySacrificeCollectionCount + "]");
                            
                                    #region TypeC
                                    _currentXPath.Push("/tns:TypeC");
                                    //6. use case
                                    if (ReadToNextElement(reader,true) && reader.LocalName == "TypeC")
                                    {
                                        if (!IsEmptyOrNilElement(reader))
                                        {
                                            ReadNext(reader);
                                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                            {
                                                currentValue = reader.Value;
                                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                                salarySacrifice.PAYEVNTEMP266 = currentValue;
                                            }
                                        }
                                        _found = true;
                                    }
                            
                                    _currentXPath.Pop();
                                    #endregion TypeC
                            
                                    #region PaymentA
                                    _currentXPath.Push("/tns:PaymentA");
                                    //6. use case
                                    if (ReadToNextElement(reader,true) && reader.LocalName == "PaymentA")
                                    {
                                        if (!IsEmptyOrNilElement(reader))
                                        {
                                            ReadNext(reader);
                                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                            {
                                                currentValue = reader.Value;
                                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                                if (Decimal.TryParse(currentValue, out currentDecimalValue))
                                                {
                                                    salarySacrifice.PAYEVNTEMP267 = currentDecimalValue;
                                                }
                                            }
                                        }
                                        _found = true;
                                    }
                            
                                    _currentXPath.Pop();
                                    #endregion PaymentA
                                _currentXPath.Pop();
                                } // End of while loop for SalarySacrifice
                            } // End of if SalarySacrificeCollection node exists
                    
                            _currentXPath.Pop();
                            #endregion SalarySacrifice
                    
                            #region LumpSum
                    
                            _currentXPath.Push("/tns:LumpSumCollection");
                            // 4. use case
                            if (ReadToNextElement(reader,false) && reader.LocalName == "LumpSumCollection")
                            {
                                remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection = new List<PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_LumpSum>();
                                remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollectionExists = true;
                    
                                _found = true;
                    
                                while ( ReadToNextElement(reader,false) && reader.LocalName == "LumpSum" ) 
                                {
                                    _found = true;
                    
                                    PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_LumpSum lumpSum = new PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_LumpSum();
                                    remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollection.Add(lumpSum);
                                    remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollectionCount += 1;
                                    lumpSum.OccurrenceIndex = remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollectionCount;
                    
                                    _currentXPath.Push("/tns:LumpSum[" + remuneration.Payee_PayrollPeriod_Remuneration_LumpSumCollectionCount + "]");
                            
                                    #region TypeC
                                    _currentXPath.Push("/tns:TypeC");
                                    //6. use case
                                    if (ReadToNextElement(reader,true) && reader.LocalName == "TypeC")
                                    {
                                        if (!IsEmptyOrNilElement(reader))
                                        {
                                            ReadNext(reader);
                                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                            {
                                                currentValue = reader.Value;
                                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                                lumpSum.PAYEVNTEMP271 = currentValue;
                                            }
                                        }
                                        _found = true;
                                    }
                            
                                    _currentXPath.Pop();
                                    #endregion TypeC
                            
                                    #region FinancialY
                                    _currentXPath.Push("/tns:FinancialY");
                                    //6. use case
                                    if (ReadToNextElement(reader,false) && reader.LocalName == "FinancialY")
                                    {
                                        if (!IsEmptyOrNilElement(reader))
                                        {
                                            ReadNext(reader);
                                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                            {
                                                currentValue = reader.Value;
                                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                                if (Int32.TryParse(currentValue, out currentIntValue))
                                                {
                                                    lumpSum.PAYEVNTEMP272 = currentIntValue;
                                                }
                                            }
                                        }
                                        _found = true;
                                    }
                            
                                    _currentXPath.Pop();
                                    #endregion FinancialY
                            
                                    #region PaymentsA
                                    _currentXPath.Push("/tns:PaymentsA");
                                    //6. use case
                                    if (ReadToNextElement(reader,true) && reader.LocalName == "PaymentsA")
                                    {
                                        if (!IsEmptyOrNilElement(reader))
                                        {
                                            ReadNext(reader);
                                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                            {
                                                currentValue = reader.Value;
                                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                                if (Decimal.TryParse(currentValue, out currentDecimalValue))
                                                {
                                                    lumpSum.PAYEVNTEMP273 = currentDecimalValue;
                                                }
                                            }
                                        }
                                        _found = true;
                                    }
                            
                                    _currentXPath.Pop();
                                    #endregion PaymentsA
                                _currentXPath.Pop();
                                } // End of while loop for LumpSum
                            } // End of if LumpSumCollection node exists
                    
                            _currentXPath.Pop();
                            #endregion LumpSum
                    
                            #region EmploymentTerminationPayment
                    
                            _currentXPath.Push("/tns:EmploymentTerminationPaymentCollection");
                            // 4. use case
                            if (ReadToNextElement(reader,false) && reader.LocalName == "EmploymentTerminationPaymentCollection")
                            {
                                remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollection = new List<PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPayment>();
                                remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollectionExists = true;
                    
                                _found = true;
                    
                                while ( ReadToNextElement(reader,false) && reader.LocalName == "EmploymentTerminationPayment" ) 
                                {
                                    _found = true;
                    
                                    PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPayment employmentTerminationPayment = new PAYEVNTEMP2020.Payee_PayrollPeriod_Remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPayment();
                                    remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollection.Add(employmentTerminationPayment);
                                    remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollectionCount += 1;
                                    employmentTerminationPayment.OccurrenceIndex = remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollectionCount;
                    
                                    _currentXPath.Push("/tns:EmploymentTerminationPayment[" + remuneration.Payee_PayrollPeriod_Remuneration_EmploymentTerminationPaymentCollectionCount + "]");
                            
                                    #region IncomeTaxPayAsYouGoWithholdingTypeC
                                    _currentXPath.Push("/tns:IncomeTaxPayAsYouGoWithholdingTypeC");
                                    //6. use case
                                    if (ReadToNextElement(reader,true) && reader.LocalName == "IncomeTaxPayAsYouGoWithholdingTypeC")
                                    {
                                        if (!IsEmptyOrNilElement(reader))
                                        {
                                            ReadNext(reader);
                                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                            {
                                                currentValue = reader.Value;
                                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                                employmentTerminationPayment.PAYEVNTEMP34 = currentValue;
                                            }
                                        }
                                        _found = true;
                                    }
                            
                                    _currentXPath.Pop();
                                    #endregion IncomeTaxPayAsYouGoWithholdingTypeC
                            
                                    #region IncomeD
                                    _currentXPath.Push("/tns:IncomeD");
                                    //6. use case
                                    if (ReadToNextElement(reader,true) && reader.LocalName == "IncomeD")
                                    {
                                        if (!IsEmptyOrNilElement(reader))
                                        {
                                            ReadNext(reader);
                                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                            {
                                                currentValue = reader.Value;
                                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                                if (DateTime.TryParse(currentValue, out currentDateTimeValue))
                                                {
                                                    employmentTerminationPayment.PAYEVNTEMP123 = currentDateTimeValue.Date;
                                                }
                                            }
                                        }
                                        _found = true;
                                    }
                            
                                    _currentXPath.Pop();
                                    #endregion IncomeD
                            
                                    #region IncomeTaxFreeA
                                    _currentXPath.Push("/tns:IncomeTaxFreeA");
                                    //6. use case
                                    if (ReadToNextElement(reader,false) && reader.LocalName == "IncomeTaxFreeA")
                                    {
                                        if (!IsEmptyOrNilElement(reader))
                                        {
                                            ReadNext(reader);
                                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                            {
                                                currentValue = reader.Value;
                                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                                if (Decimal.TryParse(currentValue, out currentDecimalValue))
                                                {
                                                    employmentTerminationPayment.PAYEVNTEMP50 = currentDecimalValue;
                                                }
                                            }
                                        }
                                        _found = true;
                                    }
                            
                                    _currentXPath.Pop();
                                    #endregion IncomeTaxFreeA
                            
                                    #region IncomeTaxableA
                                    _currentXPath.Push("/tns:IncomeTaxableA");
                                    //6. use case
                                    if (ReadToNextElement(reader,false) && reader.LocalName == "IncomeTaxableA")
                                    {
                                        if (!IsEmptyOrNilElement(reader))
                                        {
                                            ReadNext(reader);
                                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                            {
                                                currentValue = reader.Value;
                                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                                if (Decimal.TryParse(currentValue, out currentDecimalValue))
                                                {
                                                    employmentTerminationPayment.PAYEVNTEMP51 = currentDecimalValue;
                                                }
                                            }
                                        }
                                        _found = true;
                                    }
                            
                                    _currentXPath.Pop();
                                    #endregion IncomeTaxableA
                            
                                    #region IncomePayAsYouGoWithholdingA
                                    _currentXPath.Push("/tns:IncomePayAsYouGoWithholdingA");
                                    //6. use case
                                    if (ReadToNextElement(reader,false) && reader.LocalName == "IncomePayAsYouGoWithholdingA")
                                    {
                                        if (!IsEmptyOrNilElement(reader))
                                        {
                                            ReadNext(reader);
                                            if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                            {
                                                currentValue = reader.Value;
                                                ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                                if (Decimal.TryParse(currentValue, out currentDecimalValue))
                                                {
                                                    employmentTerminationPayment.PAYEVNTEMP117 = currentDecimalValue;
                                                }
                                            }
                                        }
                                        _found = true;
                                    }
                            
                                    _currentXPath.Pop();
                                    #endregion IncomePayAsYouGoWithholdingA
                                _currentXPath.Pop();
                                } // End of while loop for EmploymentTerminationPayment
                            } // End of if EmploymentTerminationPaymentCollection node exists
                    
                            _currentXPath.Pop();
                            #endregion EmploymentTerminationPayment
                        _currentXPath.Pop();
                        } // End of while loop for Remuneration
                    } // End of if RemunerationCollection node exists
            
                    _currentXPath.Pop();
                    #endregion Remuneration
            
                    #region Deduction
            
                    _currentXPath.Push("/tns:DeductionCollection");
                    // 4. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "DeductionCollection")
                    {
                        report.Payee_PayrollPeriod_DeductionCollection = new List<PAYEVNTEMP2020.Payee_PayrollPeriod_Deduction>();
                        report.Payee_PayrollPeriod_DeductionCollectionExists = true;
            
                        _found = true;
            
                        while ( ReadToNextElement(reader,false) && reader.LocalName == "Deduction" ) 
                        {
                            _found = true;
            
                            PAYEVNTEMP2020.Payee_PayrollPeriod_Deduction deduction = new PAYEVNTEMP2020.Payee_PayrollPeriod_Deduction();
                            report.Payee_PayrollPeriod_DeductionCollection.Add(deduction);
                            report.Payee_PayrollPeriod_DeductionCollectionCount += 1;
                            deduction.OccurrenceIndex = report.Payee_PayrollPeriod_DeductionCollectionCount;
            
                            _currentXPath.Push("/tns:Deduction[" + report.Payee_PayrollPeriod_DeductionCollectionCount + "]");
                    
                            #region RemunerationTypeC
                            _currentXPath.Push("/tns:RemunerationTypeC");
                            //6. use case
                            if (ReadToNextElement(reader,true) && reader.LocalName == "RemunerationTypeC")
                            {
                                if (!IsEmptyOrNilElement(reader))
                                {
                                    ReadNext(reader);
                                    if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                    {
                                        currentValue = reader.Value;
                                        ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                        deduction.PAYEVNTEMP10 = currentValue;
                                    }
                                }
                                _found = true;
                            }
                    
                            _currentXPath.Pop();
                            #endregion RemunerationTypeC
                    
                            #region RemunerationA
                            _currentXPath.Push("/tns:RemunerationA");
                            //6. use case
                            if (ReadToNextElement(reader,true) && reader.LocalName == "RemunerationA")
                            {
                                if (!IsEmptyOrNilElement(reader))
                                {
                                    ReadNext(reader);
                                    if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                    {
                                        currentValue = reader.Value;
                                        ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                        if (Decimal.TryParse(currentValue, out currentDecimalValue))
                                        {
                                            deduction.PAYEVNTEMP87 = currentDecimalValue;
                                        }
                                    }
                                }
                                _found = true;
                            }
                    
                            _currentXPath.Pop();
                            #endregion RemunerationA
                        _currentXPath.Pop();
                        } // End of while loop for Deduction
                    } // End of if DeductionCollection node exists
            
                    _currentXPath.Pop();
                    #endregion Deduction
            
                    #region SuperannuationContribution
            
                    _currentXPath.Push("/tns:SuperannuationContributionCollection");
                    // 4. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "SuperannuationContributionCollection")
                    {
                        report.Payee_PayrollPeriod_SuperannuationContributionCollection = new List<PAYEVNTEMP2020.Payee_PayrollPeriod_SuperannuationContribution>();
                        report.Payee_PayrollPeriod_SuperannuationContributionCollectionExists = true;
            
                        _found = true;
            
                        while ( ReadToNextElement(reader,false) && reader.LocalName == "SuperannuationContribution" ) 
                        {
                            _found = true;
            
                            PAYEVNTEMP2020.Payee_PayrollPeriod_SuperannuationContribution superannuationContribution = new PAYEVNTEMP2020.Payee_PayrollPeriod_SuperannuationContribution();
                            report.Payee_PayrollPeriod_SuperannuationContributionCollection.Add(superannuationContribution);
                            report.Payee_PayrollPeriod_SuperannuationContributionCollectionCount += 1;
                            superannuationContribution.OccurrenceIndex = report.Payee_PayrollPeriod_SuperannuationContributionCollectionCount;
            
                            _currentXPath.Push("/tns:SuperannuationContribution[" + report.Payee_PayrollPeriod_SuperannuationContributionCollectionCount + "]");
                    
                            #region EntitlementTypeC
                            _currentXPath.Push("/tns:EntitlementTypeC");
                            //6. use case
                            if (ReadToNextElement(reader,true) && reader.LocalName == "EntitlementTypeC")
                            {
                                if (!IsEmptyOrNilElement(reader))
                                {
                                    ReadNext(reader);
                                    if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                    {
                                        currentValue = reader.Value;
                                        ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                        superannuationContribution.PAYEVNTEMP283 = currentValue;
                                    }
                                }
                                _found = true;
                            }
                    
                            _currentXPath.Pop();
                            #endregion EntitlementTypeC
                    
                            #region EmployerContributionsYearToDateA
                            _currentXPath.Push("/tns:EmployerContributionsYearToDateA");
                            //6. use case
                            if (ReadToNextElement(reader,true) && reader.LocalName == "EmployerContributionsYearToDateA")
                            {
                                if (!IsEmptyOrNilElement(reader))
                                {
                                    ReadNext(reader);
                                    if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                    {
                                        currentValue = reader.Value;
                                        ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                        if (Decimal.TryParse(currentValue, out currentDecimalValue))
                                        {
                                            superannuationContribution.PAYEVNTEMP284 = currentDecimalValue;
                                        }
                                    }
                                }
                                _found = true;
                            }
                    
                            _currentXPath.Pop();
                            #endregion EmployerContributionsYearToDateA
                        _currentXPath.Pop();
                        } // End of while loop for SuperannuationContribution
                    } // End of if SuperannuationContributionCollection node exists
            
                    _currentXPath.Pop();
                    #endregion SuperannuationContribution
            
                    #region IncomeFringeBenefitsReportable
            
                    _currentXPath.Push("/tns:IncomeFringeBenefitsReportableCollection");
                    // 4. use case
                    if (ReadToNextElement(reader,false) && reader.LocalName == "IncomeFringeBenefitsReportableCollection")
                    {
                        report.Payee_PayrollPeriod_IncomeFringeBenefitsReportableCollection = new List<PAYEVNTEMP2020.Payee_PayrollPeriod_IncomeFringeBenefitsReportable>();
                        report.Payee_PayrollPeriod_IncomeFringeBenefitsReportableCollectionExists = true;
            
                        _found = true;
            
                        while ( ReadToNextElement(reader,false) && reader.LocalName == "IncomeFringeBenefitsReportable" ) 
                        {
                            _found = true;
            
                            PAYEVNTEMP2020.Payee_PayrollPeriod_IncomeFringeBenefitsReportable incomeFringeBenefitsReportable = new PAYEVNTEMP2020.Payee_PayrollPeriod_IncomeFringeBenefitsReportable();
                            report.Payee_PayrollPeriod_IncomeFringeBenefitsReportableCollection.Add(incomeFringeBenefitsReportable);
                            report.Payee_PayrollPeriod_IncomeFringeBenefitsReportableCollectionCount += 1;
                            incomeFringeBenefitsReportable.OccurrenceIndex = report.Payee_PayrollPeriod_IncomeFringeBenefitsReportableCollectionCount;
            
                            _currentXPath.Push("/tns:IncomeFringeBenefitsReportable[" + report.Payee_PayrollPeriod_IncomeFringeBenefitsReportableCollectionCount + "]");
                    
                            #region FringeBenefitsReportableExemptionC
                            _currentXPath.Push("/tns:FringeBenefitsReportableExemptionC");
                            //6. use case
                            if (ReadToNextElement(reader,true) && reader.LocalName == "FringeBenefitsReportableExemptionC")
                            {
                                if (!IsEmptyOrNilElement(reader))
                                {
                                    ReadNext(reader);
                                    if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                    {
                                        currentValue = reader.Value;
                                        ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                        incomeFringeBenefitsReportable.PAYEVNTEMP276 = currentValue;
                                    }
                                }
                                _found = true;
                            }
                    
                            _currentXPath.Pop();
                            #endregion FringeBenefitsReportableExemptionC
                    
                            #region A
                            _currentXPath.Push("/tns:A");
                            //6. use case
                            if (ReadToNextElement(reader,true) && reader.LocalName == "A")
                            {
                                if (!IsEmptyOrNilElement(reader))
                                {
                                    ReadNext(reader);
                                    if (reader.NodeType == XmlNodeType.Text || reader.NodeType == XmlNodeType.CDATA)
                                    {
                                        currentValue = reader.Value;
                                        ReadNext(reader); // consume the end element so we detect any validation errors before _currentXPath is updated.
                                        if (Decimal.TryParse(currentValue, out currentDecimalValue))
                                        {
                                            incomeFringeBenefitsReportable.PAYEVNTEMP277 = currentDecimalValue;
                                        }
                                    }
                                }
                                _found = true;
                            }
                    
                            _currentXPath.Pop();
                            #endregion A
                        _currentXPath.Pop();
                        } // End of while loop for IncomeFringeBenefitsReportable
                    } // End of if IncomeFringeBenefitsReportableCollection node exists
            
                    _currentXPath.Pop();
                    #endregion IncomeFringeBenefitsReportable
                } // End of if PayrollPeriod node exists
        
                _currentXPath.Pop();
                #endregion PayrollPeriod
            } // End of if Payee node exists
    
            _currentXPath.Pop();
            #endregion Payee

            while (reader.EOF != true)
                reader.Read();

            return report;
        }

        private string _elementCsvList = "Identifiers#TaxFileNumberId,Identifiers#AustralianBusinessNumberId,Identifiers#EmploymentPayrollNumberId,PreviousPayrollIDEmploymentPayrollNumberId,Identifiers,PersonNameDetails#FamilyNameT,PersonNameDetails#GivenNameT,PersonNameDetails#OtherGivenNameT,PersonNameDetails,PersonDemographicDetailsBirth#Dm,PersonDemographicDetailsBirth#M,PersonDemographicDetailsBirth#Y,PersonDemographicDetailsBirth,AddressDetails#Line1T,AddressDetails#Line2T,AddressDetails#LocalityNameT,AddressDetails#StateOrTerritoryC,AddressDetails#PostcodeT,AddressDetails#CountryC,AddressDetails,ElectronicContact#ElectronicMailAddressT,ElectronicContact#TelephoneMinimalN,ElectronicContact,EmployerConditions#EmploymentStartD,EmployerConditions#EmploymentEndD,EmployerConditions#PaymentBasisC,EmployerConditions#CessationTypeC,EmployerConditions#TaxTreatmentC,EmployerConditions#TaxOffsetClaimTotalA,EmployerConditions,PayrollPeriod#StartD,PayrollPeriod#EndD,PayrollPeriod#RemunerationPayrollEventFinalI,Remuneration#IncomeStreamTypeC,Remuneration#AddressDetailsCountryC,Remuneration#IncomeTaxPayAsYouGoWithholdingTaxWithheldA,Remuneration#IncomeTaxForeignWithholdingA,Remuneration#IndividualNonBusinessExemptForeignEmploymentIncomeA,Remuneration#GrossA,PaidLeave#TypeC,PaidLeave#PaymentA,PaidLeave,PaidLeaveCollection,Allowance#TypeC,Allowance#OtherAllowanceTypeDe,Allowance#EmploymentAllowancesA,Allowance,AllowanceCollection,Remuneration#OvertimePaymentA,Remuneration#GrossBonusesAndCommissionsA,Remuneration#GrossDirectorsFeesA,Remuneration#IndividualNonBusinessCommunityDevelopmentEmploymentProjectA,SalarySacrifice#TypeC,SalarySacrifice#PaymentA,SalarySacrifice,SalarySacrificeCollection,LumpSum#TypeC,LumpSum#FinancialY,LumpSum#PaymentsA,LumpSum,LumpSumCollection,EmploymentTerminationPayment#IncomeTaxPayAsYouGoWithholdingTypeC,EmploymentTerminationPayment#IncomeD,EmploymentTerminationPayment#IncomeTaxFreeA,EmploymentTerminationPayment#IncomeTaxableA,EmploymentTerminationPayment#IncomePayAsYouGoWithholdingA,EmploymentTerminationPayment,EmploymentTerminationPaymentCollection,Remuneration,RemunerationCollection,Deduction#RemunerationTypeC,Deduction#RemunerationA,Deduction,DeductionCollection,SuperannuationContribution#EntitlementTypeC,SuperannuationContribution#EmployerContributionsYearToDateA,SuperannuationContribution,SuperannuationContributionCollection,IncomeFringeBenefitsReportable#FringeBenefitsReportableExemptionC,IncomeFringeBenefitsReportable#A,IncomeFringeBenefitsReportable,IncomeFringeBenefitsReportableCollection,PayrollPeriod,Payee";

    }
}

