using System;
using System.IO;
using System.Runtime.CompilerServices;
using System.Text;
using System.Xml;
using System.Linq;
using System.Collections.Generic;
using DataContracts;
using System.Text.RegularExpressions;

namespace Ato.EN.IntegrationServices.CodeGenerationPAYEVNTEMPRequest2020
{

    public partial class PAYEVNTEMP2020ValidatorUpdate : PAYEVNTEMP2020RequestValidatorBase
    {
        /// <summary>
        /// The max parameter name length is restricted by the SBR1 and SBR2 schemas - the lowest common denominator of SBR 1 is used as the default
        /// </summary>
        private int _maxParameterNameLength;

        /// <summary>
        /// The max parameter value length is restricted by the SBR1 and SBR2 schemas
        /// </summary>
        private int _maxParameterValueLength;

        /// <summary>
        /// The SBR1 and ebms3 schemas do not allow parameter names or values to be the empty string
        /// </summary>
        private string _emptyParameterValue;

        /// <summary>
        /// Initializes a new instance of the <see cref="PAYEVNTEMP2018ValidatorUpdate" /> class.
        /// </summary>
        /// <param name="maxParameterNameLength">Maximum length of the parameter name.</param>
        /// <param name="maxParameterValueLength">Maximum length of the parameter value.</param>
        /// <param name="emptyParameterValue">This value will be used in place of any parameter values that result in a null or empty value.</param>
        public PAYEVNTEMP2020ValidatorUpdate(int maxParameterNameLength = 20, int maxParameterValueLength = 4096, string emptyParameterValue = "EMPTY")
        {
            _maxParameterNameLength = maxParameterNameLength;
            _maxParameterValueLength = maxParameterValueLength;
            _emptyParameterValue = emptyParameterValue;
        }

        public PAYEVNTEMP2020 ConsumedReport { get; private set; }

        private static Dictionary<string, ProcessMessageDocument> _processMessageDocuments = new Dictionary<string, ProcessMessageDocument>();

        [MethodImpl(MethodImplOptions.AggressiveInlining)]
        public override List<ProcessMessageDocument> ValidateReport(PAYEVNTEMP2020 report)
        {
            List<ProcessMessageDocument> response = new List<ProcessMessageDocument>();
            ProcessMessageDocument processMessage;
            bool assertion;

            this.ConsumedReport = report;

            // ------------------------------------------------------------------------------
            // Validations are now done in code.
            // This version supports full validation of a report - for those rules that have successfully parsed and could be generated.
            // Generated Validations include:
            //   - Validation logic in C#.
            //   - Production of errors in EBMS, SBR and SWS format.
            // 
            // The generation at this stage does not support the following - and has to be completed manually (later versions of the generation will do this for you)
            //   - Business Rules that did not parse.  The ESR team will help support you where this happens as an effort is being made to rectify these
            //   - You will get TODO tasks for those that the parser could not cope with
            // ------------------------------------------------------------------------------
            
            VRATOPAYEVNTEMP000019(report, response);
            VRATOPAYEVNTEMP000033(report, response);
            VRATOPAYEVNTEMP000034(report, response);
            VRATOPAYEVNTEMP000035(report, response);
            VRATOPAYEVNTEMP000126(report, response);
            VRATOPAYEVNTEMP000130(report, response);
            VRATOPAYEVNTEMP000131(report, response);
            VRATOPAYEVNTEMP000154(report, response);
            VRATOPAYEVNTEMP000166(report, response);
            VRATOPAYEVNTEMP000167(report, response);
            VRATOPAYEVNTEMP000168(report, response);
            VRATOPAYEVNTEMP000172(report, response);
            VRATOPAYEVNTEMP000174(report, response);
            VRATOPAYEVNTEMP000183(report, response);
            VRATOPAYEVNTEMP000201(report, response);
            VRATOPAYEVNTEMP000203(report, response);
            VRATOPAYEVNTEMP000204(report, response);
            VRATOPAYEVNTEMP000209(report, response);
            VRATOPAYEVNTEMP000210(report, response);
            VRATOPAYEVNTEMP000211(report, response);
            VRATOPAYEVNTEMP000213(report, response);
            VRATOPAYEVNTEMP000214(report, response);
            VRATOPAYEVNTEMP000215(report, response);
            VRATOPAYEVNTEMP000218(report, response);
            VRATOPAYEVNTEMP000219(report, response);
            VRATOPAYEVNTEMP000222(report, response);
            VRATOPAYEVNTEMP000224(report, response);
            VRATOPAYEVNTEMP000225(report, response);
            VRATOPAYEVNTEMP000226(report, response);
            VRATOPAYEVNTEMP000227(report, response);
            VRATOPAYEVNTEMP000228(report, response);
            VRATOPAYEVNTEMP000234(report, response);
            VRATOPAYEVNTEMP000235(report, response);
            VRATOPAYEVNTEMP000236(report, response);
            VRATOPAYEVNTEMP000237(report, response);
            VRATOPAYEVNTEMP000240(report, response);
            VRATOPAYEVNTEMP000241(report, response);
            VRATOPAYEVNTEMP000242(report, response);
            VRATOPAYEVNTEMP000244(report, response);
            VRATOPAYEVNTEMP000245(report, response);
            VRATOPAYEVNTEMP000246(report, response);
            VRATOPAYEVNTEMP000247(report, response);
            VRATOPAYEVNTEMP000248(report, response);
            VRATOPAYEVNTEMP000249(report, response);
            VRATOPAYEVNTEMP000250(report, response);
            VRATOPAYEVNTEMP000251(report, response);
            VRATOPAYEVNTEMP000253(report, response);
            VRATOPAYEVNTEMP000254(report, response);
            VRATOPAYEVNTEMP000255(report, response);
            VRATOPAYEVNTEMP000256(report, response);
            VRATOPAYEVNTEMP000257(report, response);
            VRATOPAYEVNTEMP000258(report, response);
            VRATOPAYEVNTEMP000268(report, response);
            VRATOPAYEVNTEMP000270(report, response);
            VRATOPAYEVNTEMP000272(report, response);
            VRATOPAYEVNTEMP000274(report, response);
            VRATOPAYEVNTEMP000275(report, response);
            VRATOPAYEVNTEMP000276(report, response);
            VRATOPAYEVNTEMP000277(report, response);
            VRATOPAYEVNTEMP000283(report, response);
            VRATOPAYEVNTEMP000284(report, response);
            VRATOPAYEVNTEMP000297(report, response);
            VRATOPAYEVNTEMP000298(report, response);
            VRATOPAYEVNTEMP000299(report, response);
            VRATOPAYEVNTEMP000300(report, response);
            VRATOPAYEVNTEMP000301(report, response);
            VRATOPAYEVNTEMP000302(report, response);
            VRATOPAYEVNTEMP000303(report, response);
            VRATOPAYEVNTEMP000304(report, response);
            VRATOPAYEVNTEMP000305(report, response);
            VRATOPAYEVNTEMP000306(report, response);
            VRATOPAYEVNTEMP000352(report, response);
            VRATOPAYEVNTEMP000353(report, response);
            VRATOPAYEVNTEMP000356(report, response);
            VRATOPAYEVNTEMP000357(report, response);
            VRATOPAYEVNTEMP000359(report, response);
            VRATOPAYEVNTEMP000360(report, response);
            VRATOPAYEVNTEMP000361(report, response);
            VRATOPAYEVNTEMP000362(report, response);
            VRATOPAYEVNTEMP000363(report, response);
            VRATOPAYEVNTEMP000364(report, response);
            VRATOPAYEVNTEMP000367(report, response);
            VRATOPAYEVNTEMP000368(report, response);
            VRATOPAYEVNTEMP000370(report, response);
            VRATOPAYEVNTEMP000375(report, response);
            VRATOPAYEVNTEMP000380(report, response);
            VRATOPAYEVNTEMP000381(report, response);
            VRATOPAYEVNTEMP000382(report, response);
            VRATOPAYEVNTEMP000384(report, response);
            VRATOPAYEVNTEMP000385(report, response);
            VRATOPAYEVNTEMP000386(report, response);
            VRATOPAYEVNTEMP000388(report, response);
            VRATOPAYEVNTEMP000389(report, response);
            VRATOPAYEVNTEMP000391(report, response);
            VRATOPAYEVNTEMP000392(report, response);
            VRATOPAYEVNTEMP000395(report, response);
            VRATOPAYEVNTEMP000396(report, response);
            VRATOPAYEVNTEMP000397(report, response);
			VRATOPAYEVNTEMP000400(report, response);
            VRATOPAYEVNTEMP000401(report, response);

            foreach (ProcessMessageDocument currentProcessMessage in response)
            {
                if (currentProcessMessage.Parameters != null)
                {
                    foreach (ProcessMessageParameter currentParameter in currentProcessMessage.Parameters)
                    {
                        if (string.IsNullOrEmpty(currentParameter.Name))
                        {
                            currentParameter.Name = _emptyParameterValue;
                        }

                        if (currentParameter.Name.Length > _maxParameterNameLength)
                        {
                            currentParameter.Name = currentParameter.Name.Substring(0, _maxParameterNameLength - 1);
                        }

                        if (string.IsNullOrEmpty(currentParameter.Value))
                        {
                            currentParameter.Value = _emptyParameterValue;
                        }

                        if (currentParameter.Value.Length > _maxParameterValueLength)
                        {
                            currentParameter.Value = currentParameter.Value.Substring(0, _maxParameterValueLength - 1);
                        }
                    }
                }
                }

            return response;
        }

        #region VR.ATO.PAYEVNTEMP.000174

        /*  VR.ATO.PAYEVNTEMP.000174
        Period End Date must equal the Period Start Date.

        Legacy Rule Format:
        (^PAYEVNTEMP29 <> ^PAYEVNTEMP30)

        Technical Business Rule Format:
        ^PAYEVNTEMP29 <> ^PAYEVNTEMP30

        Data Elements:

        ^PAYEVNTEMP30 = PAYEVNTEMP:Payee:PayrollPeriod:PayrollPeriod:Period.End.Date

        ^PAYEVNTEMP29 = PAYEVNTEMP:Payee:PayrollPeriod:PayrollPeriod:Period.Start.Date
        */
        public static void VRATOPAYEVNTEMP000174(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            ProcessMessageDocument processMessage = null;

            bool assertion = (report.PAYEVNTEMP29.GetValueOrDefault() != report.PAYEVNTEMP30.GetValueOrDefault());
            if (assertion)
            {
                processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000174",
                    Severity = ProcessMessageSeverity.Warning,
                    Description = @"The Period End Date must be the same as the Period Start Date",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:PayrollPeriod/tns:EndD",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000174" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP29", Value = GetValueOrEmpty(report.PAYEVNTEMP29) });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP30", Value = GetValueOrEmpty(report.PAYEVNTEMP30) });

                response.Add(processMessage);
            }
        }
        #endregion // VR.ATO.PAYEVNTEMP.000174

        #region VR.ATO.PAYEVNTEMP.000242

        /*  VR.ATO.PAYEVNTEMP.000242
        Previous Payee Payroll ID cannot be the same as Payee Payroll ID
    
        Legacy Rule Format:
        ToUppercase(Trim(^PAYEVNTEMP251)) = ToUppercase(Trim(^PAYEVNTEMP11))

        Technical Business Rule Format:
        ToUppercase(Trim(^PAYEVNTEMP251)) = ToUppercase(Trim(^PAYEVNTEMP11))
    
        Data Elements:
    
        ^PAYEVNTEMP251 = PAYEVNTEMP:Payee:Identifiers:PreviousPayrollID:Identifiers.EmploymentPayrollNumber.Identifier
    
        ^PAYEVNTEMP11 = PAYEVNTEMP:Payee:Identifiers:Identifiers.EmploymentPayrollNumber.Identifier
        */
        public static void VRATOPAYEVNTEMP000242(PAYEVNTEMP2020 report, List<ProcessMessageDocument> response)
        {
            bool assertion = string.Equals(report.PAYEVNTEMP251?.Trim(), report.PAYEVNTEMP11?.Trim(), StringComparison.CurrentCultureIgnoreCase);
            if (assertion)
            {
                ProcessMessageDocument processMessage = new ProcessMessageDocument()
                {
                    Code = "CMN.ATO.PAYEVNTEMP.000242",
                    Severity = ProcessMessageSeverity.Error,
                    Description = @"Previous Payroll ID is invalid",
                    LongDescription = @"Previous Payee Payroll ID cannot be the same as Payee Payroll ID",
                    Location = "/tns:PAYEVNTEMP/tns:Payee/tns:Identifiers/tns:PreviousPayrollIDEmploymentPayrollNumberId",
                    Parameters = new ProcessMessageParameters() { new ProcessMessageParameter() { Name = "RuleIdentifier", Value = "VR.ATO.PAYEVNTEMP.000242" } },
                };
                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP251", Value = report.PAYEVNTEMP251 });

                processMessage.Parameters.Add(new ProcessMessageParameter
                { Name = "PAYEVNTEMP11", Value = report.PAYEVNTEMP11 });

                response.Add(processMessage);
            }
        }

        #endregion // VR.ATO.PAYEVNTEMP.000242
    }
}